package Bugs;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;


public class Bug  {
    
    private Point myLocation;
    private double myDirection;
    private double mySpeed;
    protected Color myColor;
    protected long myAge;
    
    
    public Bug(int x, int y) {
        myAge=0;
        myDirection=90;
        mySpeed=10;
        myLocation=new Point(x,y);     
        myColor=Color.BLUE;
        sayHi();
    }
    
    public void sayHi() {
        System.out.println("I'm a Bug, hi!");
    }
    
    public Point getLocation(){
        return(myLocation);
    }
    
    public void act() {
        if (myAge==10){
            turn(45);
        }
        if (myAge==20){
            setSpeed(0);
        }
        
        forward();
        myAge++;
    }
    
    public void changeSpeed(double x) {
        mySpeed+=x;
        if (mySpeed<0)
            mySpeed=0;
    }
    
    public void setSpeed(double x) {
        if (x<0)
            mySpeed=0;
        else
            mySpeed=x;
    }
    
    public void turn(double angle){
        myDirection+=angle;
        limitAngle();
    }
    
    public void setDirection(double angle) {
        myDirection=angle;
        limitAngle();
    }
    
    public void limitAngle(){
        if (myDirection>359)
          while(myDirection>359)
            myDirection-=360;
        else if (myDirection<0)
          while(myDirection<0)
            myDirection+=360;
    }
    
    public void forward() {
         myLocation.x+= mySpeed*( Math.cos(Math.toRadians(myDirection)));
         myLocation.y-= mySpeed*( Math.sin(Math.toRadians(myDirection)));
    }
    
    public void draw(Graphics g) {
         g.setColor(myColor);
         g.fillOval(myLocation.x-4, myLocation.y-4, 8,8);
         int x2=myLocation.x+(int)(6*( Math.cos(Math.toRadians(myDirection))));
         int y2=myLocation.y-(int)(6*( Math.sin(Math.toRadians(myDirection))));
         g.drawLine(myLocation.x, myLocation.y, x2, y2);
    }
    
    public String toString(){
        return("I am Bug, age " + myAge + " ,  myLocation " + myLocation.x + " , " + myLocation.y);
    }
    
}
