
public class ArraySamples {

   
    public static void main(String[] args) {
        //create an array.  arrays are created using 'new'
        int[] nums = new int[10];
        //set the first index position to 123
        nums[0]=123;
        //set the last index position to 789
        nums[9]=789;
        
        //you can use the index positions just like you would any other integer variable
        //like this...
        int sum = nums[0] + nums[9];
        System.out.println("The sum is " + sum);
        
        //or like this...
        if (nums[0] < nums[9]) {
            System.out.println("First is smaller than last");
        }
        
        //you can even do this...
        nums[0]++;
        System.out.println( nums[0] );
        
        //and this...
        int position=9;
        System.out.println("Position " + position + " is " + nums[position] );
        
        //don't go outside the bounds of an array!  You will get an 'out of bounds' error.  
        //The nice thing about the error is that it will tell you which index position 
        //you tried to access that doesn't exist
        //nums[1000] = 12345;       
      
        
        //combining arrays with loops allows you to do great things. 
        
        //fill with values quickly
        for(int k=0; k<10; k++) {
            nums[k] = 999;
        }
        
        //print out the array (can copy and paste this routine when needed)
        for(int k=0; k<10; k++) {
            System.out.println("Index " + k + " --> " + nums[k] );
        }
        
        //fill with sequential values
        for(int k=0; k<10; k++) {
            nums[k] = k;
        }
    
        //or fill with random values simulating the roll of a die 1-6
        for(int k=0; k<10; k++) {
            nums[k] = (int)(Math.random()*6) + 1;
            System.out.println("Die roll " + k + " is " + nums[k] );
        }
        
        //find out how many 6's were rolled
        int count=0;
        for(int k=0; k<10; k++) {
            if (nums[k]==6){
                count++;
            }
        }
        System.out.println("There were " + count + " sixes rolled.");
        
        //where is the first 6 found in the array, if anywhere?!?
        int pos=-1;
        for(int k=0; k<10; k++) {
            if (nums[k]==6) {
                pos=k;
                break;
            }
        }
        if (pos == -1) 
            System.out.println("No sixes found!");
       else 
            System.out.println("First six found at index position " + pos);
        
        //what is the largest die roll in the array? (remember, it may not be a six!)
        int largest = nums[0];
        for(int k=1; k<10; k++) {
            if (nums[k] > largest) {
                largest = nums[k];
            }
        }
        System.out.println("The largest die roll was " + largest);
        
        //in future lessons you might be given an array that you don't know the size of.  To find out the
        //size you can use the array member   'length' .  Use it in your code so that your code will 
        //work with any size array.  If the array size changes, you don't have to change your code!
        for(int k=0; k<nums.length; k++) {
            nums[k] = nums[k] * 2;
        }
        
        //if you don't know the size of your array (in future lessons you will not know the size) and you 
        //want to set the last value in the array to 999, you could do this
        nums[ nums.length-1 ] = 999;
        
        //swapping values at two different index positions is a common task.  
        //Here's an array set to store numbers nicely in sequential order
        int[] list = new int[8];
        for(int k=0; k<list.length; k++) {
            list[k] = k;
        }
        
        //bad swap!
        //   list[0] = list[1];
        //   list[1] = list[0];
        
        //good swap the first and second values in the array
        int temp=list[0];
        list[0] = list[1];
        list[1] = temp;
        
        //check to see if they were swapped
        for(int k=0; k<list.length; k++) {
            System.out.println("Index " + k + " is " + list[k] );
        }
        
        //select two index positions in the array and swap their values
        int pos1 = (int)(Math.random()*list.length);   //0-7
        int pos2 = (int)(Math.random()*list.length);
        int value = list[pos1];
        list[pos1] = list[pos2];
        list[pos2] = value;        
        
        //check to see if they were swapped
        for(int k=0; k<list.length; k++) {
            System.out.println("Index " + k + " is " + list[k] );
        }
        
        
        //can you write a routine that would shuffle the location of the 8 numbers in the list above?
        //(as if you are shuffling a deck of cards - so if you start with 0,1,2,3,4,5,6,7 you might end with
        //6,4,5,1,2,0,7,3
        for(int k=0; k<list.length; k++) {
            list[k] = k;
        }
        
        for(int k=0; k<list.length*2; k++) {
            //pick two slots to swap
            int loc1 = (int)(Math.random()*list.length);
            int loc2 = (int)(Math.random()*list.length);
            int remember = list[loc1];
            list[loc1] = list[loc2];
            list[loc2] = remember;
        }
        
        for(int k=0; k<list.length;k++){
            System.out.println("Index " + k + " is --> " + list[k] );
        }
        
        //oh ya! all done the basics!
        
    } //end main
    
} //end class
