
public class StringsImmutable {
    
    public static void main(String[] args){
        
        //String literals are interned in the String Constant Pool... 
        //identical strings will refer to same string in memory
        String word1 = "hi";
        String word2 = "hi";
        System.out.println(word1==word2);
        
        //Strings are immutable and changing the string creates an entirely new string
        //literal in a different spot in memory. 
        word1 = word1 + "ppy";
        System.out.println(word1);
        System.out.println(word2);
        System.out.println(word1==word2);
        System.out.println("********");
        
        //each String object created is a new object in memory (not in the string literal area)
        //are not string literals.
        
        String word3 = new String("ball");
        String word4 = new String("ball");
        System.out.println(word3==word4);
        String word5 = "ball";
        System.out.println(word3==word5);
        word3 = "abc";
        word4 = "abc";
        System.out.println(word3==word4);
        
    }
}
