package seachingexamples;

/*
 *This frame contains a few standard array sorting and
 * searching algorithms that you must master.
 * Keep in mind that you must FILL the array to make sure
 * your array has numbers in it, and REFRESH the list to
 * see any changes you make on the list.
 */

import java.util.Random;
import java.awt.Graphics;
import java.awt.Color;
import java.awt.Image;


public class ArraySearchSortFrame extends javax.swing.JFrame {


    public int[] nums = new int[20];
    public Random R = new Random();
    public Image offscreen;
    int delayTime = 35;
    
    /** Creates new form ArraySearchSortFrame */
    public ArraySearchSortFrame() {
        initComponents();
        offscreen = createImage(getSize().width,getSize().height); 
        textDelayTime.setText( Integer.toString(delayTime) );
        fillArray();
        fillList();
        updateGraph();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        buttonRandomFill = new java.awt.Button();
        theList = new java.awt.List();
        label1 = new java.awt.Label();
        canvas1 = new java.awt.Canvas();
        buttonSequentialSearch = new java.awt.Button();
        buttonBinarySearch = new java.awt.Button();
        textNumber = new java.awt.TextField();
        textResult = new java.awt.TextField();
        buttonBubbleSort = new java.awt.Button();
        buttonSelectionSort = new java.awt.Button();
        buttonInsertSort = new java.awt.Button();
        label2 = new java.awt.Label();
        label3 = new java.awt.Label();
        sliderDelay = new javax.swing.JSlider();
        textDelayTime = new javax.swing.JTextField();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);

        buttonRandomFill.setLabel("randomFill");
        buttonRandomFill.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                buttonRandomFillActionPerformed(evt);
            }
        });

        label1.setFont(new java.awt.Font("Dialog", 0, 14)); // NOI18N
        label1.setText("Array Search and Sort Frame Extreme");

        buttonSequentialSearch.setLabel("sequentialSearch");
        buttonSequentialSearch.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                buttonSequentialSearchActionPerformed(evt);
            }
        });

        buttonBinarySearch.setLabel("binarySearch");
        buttonBinarySearch.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                buttonBinarySearchActionPerformed(evt);
            }
        });

        textNumber.setFont(new java.awt.Font("Dialog", 0, 14)); // NOI18N

        textResult.setFont(new java.awt.Font("Dialog", 0, 14)); // NOI18N

        buttonBubbleSort.setLabel("BubbleSort");
        buttonBubbleSort.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                buttonBubbleSortActionPerformed(evt);
            }
        });

        buttonSelectionSort.setLabel("SelectionSort");
        buttonSelectionSort.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                buttonSelectionSortActionPerformed(evt);
            }
        });

        buttonInsertSort.setLabel("InsertSort");
        buttonInsertSort.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                buttonInsertSortActionPerformed(evt);
            }
        });

        label2.setText("#");

        label3.setText("result");

        sliderDelay.setMinimum(1);
        sliderDelay.setMinorTickSpacing(10);
        sliderDelay.setPaintTicks(true);
        sliderDelay.setValue(35);
        sliderDelay.setValueIsAdjusting(true);
        sliderDelay.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                sliderDelayMouseReleased(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(canvas1, javax.swing.GroupLayout.DEFAULT_SIZE, 332, Short.MAX_VALUE)
                    .addComponent(label1, javax.swing.GroupLayout.DEFAULT_SIZE, 332, Short.MAX_VALUE)
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                            .addComponent(buttonSequentialSearch, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(buttonRandomFill, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(buttonBinarySearch, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(layout.createSequentialGroup()
                                .addComponent(sliderDelay, javax.swing.GroupLayout.PREFERRED_SIZE, 129, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addGap(6, 6, 6)
                                .addComponent(textDelayTime, 0, 0, Short.MAX_VALUE)
                                .addGap(22, 22, 22))
                            .addGroup(layout.createSequentialGroup()
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addGroup(layout.createSequentialGroup()
                                        .addGap(22, 22, 22)
                                        .addComponent(label2, javax.swing.GroupLayout.PREFERRED_SIZE, 33, javax.swing.GroupLayout.PREFERRED_SIZE)
                                        .addGap(20, 20, 20)
                                        .addComponent(label3, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                                    .addGroup(layout.createSequentialGroup()
                                        .addComponent(textNumber, javax.swing.GroupLayout.PREFERRED_SIZE, 47, javax.swing.GroupLayout.PREFERRED_SIZE)
                                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                        .addComponent(textResult, javax.swing.GroupLayout.PREFERRED_SIZE, 63, javax.swing.GroupLayout.PREFERRED_SIZE)))
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 89, Short.MAX_VALUE)))))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(theList, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 94, Short.MAX_VALUE)
                    .addComponent(buttonInsertSort, javax.swing.GroupLayout.DEFAULT_SIZE, 94, Short.MAX_VALUE)
                    .addComponent(buttonSelectionSort, javax.swing.GroupLayout.DEFAULT_SIZE, 94, Short.MAX_VALUE)
                    .addComponent(buttonBubbleSort, javax.swing.GroupLayout.DEFAULT_SIZE, 94, Short.MAX_VALUE))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGap(11, 11, 11)
                .addComponent(label1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addGroup(javax.swing.GroupLayout.Alignment.LEADING, layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                            .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                .addGroup(layout.createSequentialGroup()
                                    .addGap(9, 9, 9)
                                    .addComponent(buttonRandomFill, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                                    .addComponent(buttonBubbleSort, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addComponent(textDelayTime, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                            .addComponent(sliderDelay, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                            .addGroup(javax.swing.GroupLayout.Alignment.LEADING, layout.createSequentialGroup()
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addComponent(textNumber, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                    .addComponent(textResult, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                                    .addComponent(label3, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addComponent(label2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                            .addGroup(javax.swing.GroupLayout.Alignment.LEADING, layout.createSequentialGroup()
                                .addComponent(buttonSequentialSearch, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addGap(2, 2, 2)
                                .addComponent(buttonBinarySearch, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))))
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(buttonSelectionSort, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(buttonInsertSort, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addGap(15, 15, 15)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(canvas1, 0, 0, Short.MAX_VALUE)
                    .addComponent(theList, javax.swing.GroupLayout.DEFAULT_SIZE, 309, Short.MAX_VALUE))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    public void fillArray(){
        for(int k=0; k<nums.length; k++){
            nums[k] = R.nextInt(200);
        }
    }

    public void delay(){
        try{
            Thread.sleep(delayTime);
        }catch(Exception e){}
    }

    public void fillList(){
        theList.removeAll();
        for(int k=0; k<nums.length; k++){
            theList.add( Integer.toString(nums[k]));
        }
    }
    
    public void updateGraph(){
        Graphics g = offscreen.getGraphics();
        
        g.clearRect(0,0,offscreen.getWidth(null), offscreen.getHeight(null) );
        for(int k=0; k<nums.length; k++){
            g.fillRect(5+k*15, 300-nums[k], 12, nums[k]);
        }
        canvas1.getGraphics().drawImage(offscreen, 0, 0, null);
    }

    private void buttonRandomFillActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_buttonRandomFillActionPerformed
        fillArray();
        fillList();
        updateGraph();
        
    }//GEN-LAST:event_buttonRandomFillActionPerformed

    private void buttonBubbleSortActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_buttonBubbleSortActionPerformed
        //bubble sort the array!!!
        for(int a=0; a<nums.length-1; a++)
            for(int b=0; b<nums.length-1-a; b++){
                if (nums[b] > nums[b+1]){
                    int temp = nums[b];
                    nums[b] = nums[b+1];
                    nums[b+1] = temp;
                }
                updateGraph(); 
                delay();
            }
        fillList();
    }//GEN-LAST:event_buttonBubbleSortActionPerformed

    private void buttonSelectionSortActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_buttonSelectionSortActionPerformed
      //selection sort the array!!!
        for (int i=0; i<nums.length-1; i++){
           int posOfLowest = i;			
           for (int j=i+1; j<nums.length; j++){
               if (nums[j] < nums[posOfLowest])	
                   posOfLowest = j;					
           }
           int temp = nums[i];			
           nums[i] = nums[posOfLowest];
           nums[posOfLowest] = temp;
           updateGraph(); 
           delay();
       }
       
       fillList();
    }//GEN-LAST:event_buttonSelectionSortActionPerformed
    

    private void buttonBinarySearchActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_buttonBinarySearchActionPerformed
        //look for this
        int x = Integer.parseInt( textNumber.getText() );
        //binary search!
        int lo = 0;
        int hi = nums.length - 1;
        while (lo <= hi) {
            int mid = lo + (hi - lo) / 2;
            if (x < nums[mid]) { 
                hi = mid - 1;
                System.out.println("Moved HI to " + hi);
            }
            else if (x > nums[mid]) {
                lo = mid + 1;
                System.out.println("Moved LO to " + lo);
            }
            else {
                System.out.println("Found it at " + mid);
                textResult.setText( Integer.toString( mid) );
                return;  //get out of this method
            }  
            
        }
        
        //not found if we make it here...
        textResult.setText( Integer.toString( -1 ) );
    }//GEN-LAST:event_buttonBinarySearchActionPerformed

    private void buttonSequentialSearchActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_buttonSequentialSearchActionPerformed
        int num = Integer.parseInt( textNumber.getText() );
        
        int position = -1;
        for(int k=0; k<nums.length; k++)
            if (nums[k] == num){
                position=k;
                textResult.setText( Integer.toString( position ) );
                return;
            }        
        textResult.setText( Integer.toString(-1) );
    }//GEN-LAST:event_buttonSequentialSearchActionPerformed

    private void sliderDelayMouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_sliderDelayMouseReleased
        delayTime = sliderDelay.getValue();
        textDelayTime.setText(Integer.toString(delayTime));
    }//GEN-LAST:event_sliderDelayMouseReleased

    private void buttonInsertSortActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_buttonInsertSortActionPerformed
      //Insertion Sort
      for (int i = 1; i < nums.length; i++){
  	int j = i;                                                   
  	int B = nums[i];
 	while ( (j > 0) && (nums[j-1] > B) ){
  	    	nums[j] = nums[j-1];                  
  	    	j--;
                              updateGraph(); 
                              delay(); 
 	}
 	nums[j] = B;
               updateGraph(); 
               delay();        
      }
      
      fillList();
    }//GEN-LAST:event_buttonInsertSortActionPerformed

    /**
    * @param args the command line arguments
    */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new ArraySearchSortFrame().setVisible(true);
            }
        });
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private java.awt.Button buttonBinarySearch;
    private java.awt.Button buttonBubbleSort;
    private java.awt.Button buttonInsertSort;
    private java.awt.Button buttonRandomFill;
    private java.awt.Button buttonSelectionSort;
    private java.awt.Button buttonSequentialSearch;
    private java.awt.Canvas canvas1;
    private java.awt.Label label1;
    private java.awt.Label label2;
    private java.awt.Label label3;
    private javax.swing.JSlider sliderDelay;
    private javax.swing.JTextField textDelayTime;
    private java.awt.TextField textNumber;
    private java.awt.TextField textResult;
    private java.awt.List theList;
    // End of variables declaration//GEN-END:variables

}
