import java.awt.Point;

//the Point class is a 'built in' class that comes with Java.  You can look up the
//information about the class at 
// https://docs.oracle.com/javase/7/docs/api/java/awt/Point.html

public class Circle {
    
    private Point origin;
    private int radius;
    
    public Circle() {
        origin = new Point(0,0);
        radius=0; 
    }
    
    public Circle(Point p, int r) {
        origin = p;
        radius = r;
    }
    
    public Point getOrigin(){
        return(origin);
    }
    
    public int getRadius() {
        return(radius);
    }
    
    public void translate(int distx, int disty) {
        origin.x = origin.x + distx;
        origin.y = origin.y + disty;
    }
    
    public void moveTo(Point p) {
        origin = p;
    }
    
    public void setRadius(int r) {
        if (r>0)
            radius = r;
    }
    
}
